// phone_sample.cpp
//
// Melissa Data mdName API for C++ Windows/Linux/Unix
// Copyright 1993-2007 Melissa Data Corporation.

//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples,
//we welcome you to contact us at SampleCode@melissadata.com also please visit our
//developers bulletin board at forum.melissadata.com.
//********************************************************************************

#include <iostream>

#include "mdPhone.h"
using namespace std;

const char bar[]="========================================================================\n";

      /********************** LICENSE STRINGS ***********************
		*     To unlock the full functionality of Phone Object,       *
		* please call a sales representative at 1-800-MELISSA ext. 3  *
		*         (1-800-635-4772 x3) for a license string.           *
		*     Without a valid license string, the demo will process   *
		*                only code Nevada Zip Codes.                  *
		**************************************************************/
#define dLICENSE "DEMO"

      /********************** DATA FILE PATHS **********************
		*    This sample sets the data file path to the installation *
		* default.  If you installed your Melissa Data data files to *
		* a different path, enter that location it below.            *
		* The Data Files Directory must contain the following files: *
		* mdAddr.dat, mdPhone.dat, mdPhone.idx and ZIPNPA.TXT.       *
		*************************************************************/
#define dFILELOC "C:\\Program Files\\Melissa Data\\DQT\\Data"

int main(int argc,char **argv)
{
    char phone[20], zip[15];
	const char* results;

    double      lat1;             // latitude of first point
    double      lon1;             // longitude of first point
    float distance, bearing;

    mdPhone  *ph = new mdPhone;

	if (!ph->SetLicenseString(dLICENSE)) {
		cout << "Error setting License to : " << dLICENSE <<endl;
		cout << "Please contact a sales representative at 1-800-800-6245 x3 for a valid license string" << endl;
		return 1;
	}
	
	if (ph->Initialize(dFILELOC)!= mdPhone::ErrorNone) {
		cout << "Error Initializing mdName: " << ph->GetInitializeErrorString() << endl;
		return 1;
	}
    cout << "          Build Number: " << ph->GetBuildNumber() << endl;
	cout << "         Database Date: " << ph->GetDatabaseDate() << endl;
	
        /***************************************************************
		 *  Remember, without a valid license, you can only process    *
		 *  Nevada numbers - for example:                              *
         *      PhoneNumber: 702-896-5154                              *
		 *	   ZipCode: = 89119                                        *
         ***************************************************************/

	cout << " Input Phone (ex: 702-896-5154): ";        cin.getline(phone,sizeof phone);
	cout << "     Input Zip Code (ex: 89119): ";        cin.getline(zip,sizeof zip);

ph->Lookup(phone,zip);

cout << endl << "Results..." << endl;
results = ph->GetResults();
if ((strstr(results,"PS01")!=0) || (strstr(results,"PS02")!=0))
{
		if (strstr(results,"PS01")!=0)
              cout << "Phone validated to 10 digits" << endl;
        else if (strstr(results,"PS02")!=0)
              cout << "Phone validated to 7 digits" << endl;
		
		if (strstr(results,"PS07")!=0)
               cout << "Exchange Type: Cellular" << endl;
        if (strstr(results,"PS08")!=0)
               cout << "Exchange Type: Land Line" << endl;
        else if (strstr(results,"PS09")!=0)
               cout << "Exchange Type: Voip" << endl;

		if (strstr(results,"PS10")!=0)
               cout << "Phone Type: Residential" << endl;
        if (strstr(results,"PS11")!=0)
               cout << "Phone Type: Business" << endl;
        if (strstr(results,"PS12")!=0)
               cout << "Phone Type: Small/Home Office" << endl;

		if (strstr(results,"PS06")!=0)
               cout << "New Area Code Furnished" << endl;

    cout << endl;
    cout << "AreaCode    : " << ph->GetAreaCode() << endl;
    cout << "NewAreaCode : " << ph->GetNewAreaCode() << endl;
    cout << "Prefix      : " << ph->GetPrefix() << endl;
    cout << "Suffix      : " << ph->GetSuffix() << endl;
    cout << "Extension   : " << ph->GetExtension() << endl;
    cout << endl;

    cout << "City        : " << ph->GetCity() << endl;
    cout << "State       : " << ph->GetState() << endl;
    cout << "CountyFips  : " << ph->GetCountyFips() << endl;
    cout << "CountyName  : " << ph->GetCountyName() << endl;
    cout << "Msa         : " << ph->GetMsa() << endl;
    cout << "Pmsa        : " << ph->GetPmsa() << endl;
    cout << "TimeZone    : " << ph->GetTimeZone() << endl;
    cout << "TimeZoneCode: " << ph->GetTimeZoneCode() << endl;
    cout << "CountryCode : " << ph->GetCountryCode() << endl;
    cout << "Latitude    : " << ph->GetLatitude() << endl;
    cout << "Longitude   : " << ph->GetLongitude() << endl;
    cout << "Distance    : " << ph->GetDistance() << endl;
    cout << endl;

	cout <<"==============================================" << endl;
	cout <<"        Distance and Bearing Example"<< endl;
	cout <<" Lat / Long of US Capital: 38.889722  -77.0075 "<< endl;
	cout <<"=============================================="<< endl;
	lat1 = atof(ph->GetLatitude());
	lon1 = atof(ph->GetLongitude());
	distance = ph->ComputeDistance(lat1, lon1, 38.889722, -77.0075);
	bearing = ph->ComputeBearing(lat1, lon1, 38.889722, -77.0075);
	cout <<" Distance: " << distance << "miles" << endl;
	cout <<"  Bearing: " << bearing << "degrees" << endl;
	cout << endl;

	ph->CorrectAreaCode(phone,zip);
	results = ph->GetResults();
    if (strstr(results,"PS03")!=0)
		{
			cout << "==============================="<< endl;
			cout << "  Corrected Area Code Results"<< endl;
			cout << "==============================="<< endl;
			cout << "    Area Code: "  << ph->GetAreaCode() << endl;
			cout << "New Area Code: "  << ph->GetNewAreaCode() << endl;
			cout << "       Prefix: "  << ph->GetPrefix() << endl;
			cout << "       Suffix: "  << ph->GetSuffix() << endl;
			cout << "    Extension: "  << ph->GetExtension() << endl;
		}

} else if ((strstr(results,"PS04")!=0) || (strstr(results,"PS05")!=0)){
    // program could not process the number
    if (strstr(results,"PS04")!=0)
       cout << "PS04: Phone number is outside the Demo range (Nevada)" << endl;
    if (strstr(results,"PS05")!=0)
       cout << "PS05: Expired Database The database has expired. Contact Melissa Data" << endl;

} else if (strstr(results,"PE")!=0){
    //there was an error validating the number
    if (strstr(results,"PE01")!=0)
        cout << "PE01: Bad Area Code" << endl;
    if (strstr(results,"PE02")!=0)
        cout << "PE02: Blank Phone Number" << endl;
    if (strstr(results,"PE03")!=0)
        cout << "PE03: Too few or too many digits" << endl;
    if (strstr(results,"PE04")!=0)
        cout << "PE04: Multiple Match" << endl;
    if (strstr(results,"PE05")!=0)
        cout << "PE05: Bad prefix" << endl;
    if (strstr(results,"PE06")!=0)
        cout << "PE06: Bad Zip Code" << endl;
}



    // clean up after ourselves
    delete ph;
    ph = NULL;
    
    return 0;
}  //end main
